#include <sys/types.h>
#include <sys/mman.h>

main()
{

    caddr_t	addr1;
    caddr_t	addr2;
    int		*ip;
    int		i;

    printf("MMAP test.  Mapping 64K at 0x8000000\n");
    addr1 = mmap(0x8000000, 0x10000, PROT_READ|PROT_WRITE|PROT_EXEC, 
				MAP_ANON|MAP_FIXED|MAP_PRIVATE, 0, 0);
    if((long)addr1 < 0) {
	perror("mmap");
    }
    printf("mmap returns 0x%lx\n", addr1);

    /* Fill with one pattern... */
    for(i = 0, ip=(int*)addr1; i < (0x10000/sizeof(int)); i++, ip++) {
	*ip = 0x01020304;
    }

    if(mprotect(0x8000000, 0x10000, PROT_READ|PROT_EXEC) < 0) {
	perror("mprotect");
    }
    
    printf("MMAP test.  Mapping 64K at 0x8004000\n");
    addr2 = mmap(0x8004000, 0x10000, PROT_READ|PROT_WRITE, 
				MAP_ANON|MAP_FIXED|MAP_PRIVATE, 0, 0);
    if((long)addr2 < 0) {
	perror("mmap");
    }
    printf("mmap returns 0x%lx\n", addr2);

    /* Check the first pattern... */
    for(i = 0, ip=(int*)addr1; i < (0x10000/sizeof(int)); i++, ip++) {
	if(*ip != 0x01020304) {
	    printf("miscompare @0x%lx expect 0x%x got 0x%x\n", ip, 0x01020304, *ip);
	    break;
	}
    }
}
    
