#include <stdio.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <syscall_thunk.h>
#include <errno.h>

void alpha_to_new_x86_stat(struct stat *alpha_st, struct x86_new_stat *x86_st)
{
    x86_st->st_dev = alpha_st->st_dev;
    x86_st->st_ino = alpha_st->st_ino;
    x86_st->st_mode = alpha_st->st_mode;
    x86_st->st_nlink = alpha_st->st_nlink;
    x86_st->st_uid = alpha_st->st_uid;
    x86_st->st_gid = alpha_st->st_gid;
    x86_st->st_rdev = alpha_st->st_rdev;
    x86_st->st_size = alpha_st->st_size;
    x86_st->st_blksize = alpha_st->st_blksize;
    x86_st->st_blocks = alpha_st->st_blocks;
    x86_st->st_atime = (unsigned int)(alpha_st->st_atime & 0xffffffff);
    x86_st->st_mtime = (unsigned int)(alpha_st->st_mtime & 0xffffffff);
    x86_st->st_ctime = (unsigned int)(alpha_st->st_ctime & 0xffffffff);
}

void alpha_to_old_x86_stat(struct stat *alpha_st, struct x86_old_stat *x86_st)
{
    x86_st->st_dev = alpha_st->st_dev;
    x86_st->st_ino = alpha_st->st_ino;
    x86_st->st_mode = alpha_st->st_mode;
    x86_st->st_nlink = alpha_st->st_nlink;
    x86_st->st_uid = alpha_st->st_uid;
    x86_st->st_gid = alpha_st->st_gid;
    x86_st->st_rdev = alpha_st->st_rdev;
    x86_st->st_size = alpha_st->st_size;
    x86_st->st_atime = (unsigned int)(alpha_st->st_atime & 0xffffffff);
    x86_st->st_mtime = (unsigned int)(alpha_st->st_mtime & 0xffffffff);
    x86_st->st_ctime = (unsigned int)(alpha_st->st_ctime & 0xffffffff);
}


int	do_newfstat(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int fd = a0;
    struct x86_new_stat *x86_st = ARG_TO_POINTER(a1);
    struct stat	st;
    int retval;

    retval = fstat(fd, &st);
    if(retval < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    alpha_to_new_x86_stat(&st, x86_st);
    return(0);
}


int	do_newstat(int a0, int a1, int a2, int a3, int a4, int a5)
{
    char *filename = ARG_TO_POINTER(a0);
    struct x86_new_stat *x86_st = ARG_TO_POINTER(a1);
    struct stat	st;
    int retval;

    retval = stat(filename, &st);
    if(retval < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    alpha_to_new_x86_stat(&st, x86_st);
    return(0);
}

int	do_newlstat(int a0, int a1, int a2, int a3, int a4, int a5)
{
    char *filename = ARG_TO_POINTER(a0);
    struct x86_new_stat *x86_st = ARG_TO_POINTER(a1);
    struct stat	st;
    int retval;

    retval = lstat(filename, &st);
    if(retval < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    alpha_to_new_x86_stat(&st, x86_st);
    return(0);
}


int	do_oldfstat(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int fd = a0;
    struct x86_old_stat *x86_st = ARG_TO_POINTER(a1);
    struct stat	st;
    int retval;

    retval = fstat(fd, &st);
    if(retval < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    alpha_to_old_x86_stat(&st, x86_st);
    return(0);
}


int	do_oldstat(int a0, int a1, int a2, int a3, int a4, int a5)
{
    char *filename = ARG_TO_POINTER(a0);
    struct x86_old_stat *x86_st = ARG_TO_POINTER(a1);
    struct stat	st;
    int retval;

    retval = stat(filename, &st);
    if(retval < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    alpha_to_old_x86_stat(&st, x86_st);
    return(0);
}

int	do_oldlstat(int a0, int a1, int a2, int a3, int a4, int a5)
{
    char *filename = ARG_TO_POINTER(a0);
    struct x86_old_stat *x86_st = ARG_TO_POINTER(a1);
    struct stat	st;
    int retval;

    retval = lstat(filename, &st);
    if(retval < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    alpha_to_old_x86_stat(&st, x86_st);
    return(0);
}
